#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Corny tunnelMod01.fsh by  Plento
//https://www.shadertoy.com/view/Ml3fR2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define FAR 80.0 //80.0
#define DISTANCE_BIAS 0.75  //0.75


const float pi = 3.14159265359;

mat2 rot(float a) {
    return mat2(cos(a), -sin(a), sin(a), cos(a));
}

float opU(float d1, float d2){return min(d1, d2);}


float map(vec3 rp)
{
 
   float res;
   
   // messed around till it looked like a tunnel
   rp.z += iTime;
   float c = sin(rp.z*1.5 + rp.y*0.4 + iTime )*0.5 ;
   rp.xy *= rot(sin(c*1.0));
   
   rp.x += c;
   
   // simple tunnel distance function
   res =  3.0-max(rp.x, -rp.y) ;
   res = opU(res, 3.0 - max(-rp.x, rp.y));
    
   return res;
}

vec3 getNormal(vec3 p)
{
    vec2 e = vec2(0.0035, -0.0035); 
    return normalize(
        e.xyy * map(p + e.xyy) + 
        e.yyx * map(p + e.yyx) + 
        e.yxy * map(p + e.yxy) + 
        e.xxx * map(p + e.xxx));
}

vec3 color(vec3 ro, vec3 rd, vec3 norm, float md, float t)
{
    // Lighting
    vec3 lp = ro + vec3(-1.0, 2.5, -5.0)*10.0; 
	vec3 ld = normalize(lp - (ro + rd*t));
    vec3 p = (ro+rd)*t;
    
    vec3 tex = texture2D(iChannel0, norm.xy*0.2).xyz;
    
    // Snowy stuff
    float avg = (tex.r + tex.b + tex.g) / 3.0;
    //float d = smoothstep(0.4,0.6, avg); // smoother looking but I liked the rough one
   float d = step(0.45, avg);
    
    tex += d;
    
    // Diffuse
    float diff = max(dot(norm, ld), 0.0);
    
    vec3 sceneCol;
    
    // Get final color
    sceneCol = (tex*(diff + 0.15));
    
    // fog
    sceneCol =  mix( sceneCol, vec3(0.0,0.0,0.0), 1.0 - exp( -0.005*t*t*t ) );
    
    return sceneCol;
    
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = 2.0 * vec2(fragCoord.xy - 0.5*iResolution.xy)/iResolution.y; 
   
    // Ray origin (camera)
     vec3 ro = vec3(0.0, 0.0, 0.0); 
    
    // Ray direction
    vec3 rd = normalize(vec3(uv,1.0));
    
    float t = 0.0; 
    float d; 
    
    float minDist = 999.0; 
    
    bool hit = false;
    
    for (int i = 0; i < 64; i++) // raymarch
    {
        d = map(ro + rd*t);
        
        minDist = min(minDist, d); 
        
        if(abs(d)<0.0001) 
        {
            minDist = abs(d);
            hit = true;
            break;  
        }
        if(t>FAR) 
        {
            minDist = min(minDist, d);
            t = FAR;
            hit = false;
            break;
        }
        
        t += d * DISTANCE_BIAS;
    }
    
    vec3 col = vec3(0.0, 0.0, 0.0); // main color
    
    vec3 norm = getNormal(ro + rd * t); // get normal of hit point
    
     // final color with the gamma correction 
    col = color(ro, rd, norm, minDist, t);
    
    fragColor = vec4(sqrt(clamp(col, 0.0, 1.0)), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

